'******************************************************************************
' DHCP declarations (UDP required))
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile                                                      'will compile only as an include file

'******************************************************************************
' Constants and variables
'******************************************************************************
Const Dhcp_status_init = 0
Const Dhcp_status_rebinding = 1
Const Dhcp_status_renewing = 2
Const Dhcp_status_bound = 3
Const Dhcp_op_bootrequest = 1
Const Dhcp_op_bootreply = 2
Const Dhcp_cookie = &H63538263                              'reversed 99.130.83.99
Const Dhcp_msg_type_dhcpdiscover = 1
Const Dhcp_msg_type_dhcpoffer = 2
Const Dhcp_msg_type_dhcprequest = 3
Const Dhcp_msg_type_dhcpdecline = 4
Const Dhcp_msg_type_dhcpack = 5
Const Dhcp_msg_type_dhcpnak = 6
Const Dhcp_msg_type_dhcprelease = 7
Const Dhcp_msg_type_dhcpinform = 8
Const Dhcp_opt_message_type = 53
Const Dhcp_opt_parameter_request_list = 55
Const Dhcp_opt_requested_ip_address = 50
Const Dhcp_opt_client_identifier = 61
Const Dhcp_opt_client_identifier_mac = 1
Const Dhcp_opt_hostname = 12
Const Dhcp_hwtype_eth10mb = 1
Const Dhcp_options_start = 283
Const Dhcp_flags_broadcast = &H0080                         'reversed 8000          '
Const Dhcp_flags_no_broadcast = &H0000                      'reversed 0000

Dim Dhcp_transaction_id As Long
Dim Dhcp_status As Byte
Dim Dhcp_secs_elapsed As Word
Dim Dhcp_lease_time As Long
Dim Dhcp_renew_time As Long
Dim Dhcp_rebinding_time As Long
Dim Dhcp_b_recent_server_ip(4) As Byte

'******************************************************************************
' DHCP Frame
'******************************************************************************
Dim Dhcp_b_opcode As Byte At Buffer(43) Overlay
Dim Dhcp_b_hwtype As Byte At Buffer(44) Overlay
Dim Dhcp_b_hwlen As Byte At Buffer(45) Overlay
Dim Dhcp_b_hops As Byte At Buffer(46) Overlay
Dim Dhcp_l_transaction_id As Long At Buffer(47) Overlay
Dim Dhcp_w_secs As Word At Buffer(51) Overlay
Dim Dhcp_w_flags As Word At Buffer(53) Overlay
Dim Dhcp_b_ciaddr(4) As Byte At Buffer(55) Overlay
Dim Dhcp_b_yiaddr(4) As Byte At Buffer(59) Overlay
Dim Dhcp_b_siaddr(4) As Byte At Buffer(63) Overlay
Dim Dhcp_b_giaddr(4) As Byte At Buffer(67) Overlay
Dim Dhcp_b_chaddr(16) As Byte At Buffer(71) Overlay
Dim Dhcp_b_sname(64) As Byte At Buffer(87) Overlay
Dim Dhcp_b_file(128) As Byte At Buffer(151) Overlay
Dim Dhcp_l_dhcp_cookie As Long At Buffer(279) Overlay
Dim Dhcp_b_options_start As Byte At Buffer(dhcp_options_start) Overlay

'******************************************************************************
' Subroutines
'******************************************************************************
Declare Sub Dhcp_initialize
'( Aufruf aus dem Hauptprogramm
   Der Dhcp Status Wird Auf Init Gestellt Und Ein Dhcp Discover Paket Gesendet.
')
Declare Sub Dhcp_every_minute
'( Aufruf aus dem Hauptprogramm
   Diese Routine Sollte Aus Dem Hauptprogramm Heraus Etwa 1 X Pro Minute Aufgerufen Werden.
   Es Werden Die Timer Fr Rebind , Renew Und Lease Heruntergezhlt,
   Bei Erreichen Der Null Erfolgt Eine Entsprechende nderung Des Dhcp Status.
   Anschlieend Wird Je Nach Dann Gltigen Status Eine Entsprechede Aktion Ausgelst:
   Status Bound - > Keine Aktion
   Status Init - > Dhcp Discover
   Status Renew Oder Rebind - > Dhcp Request
')
Declare Sub Dhcp_create_new_xid
'(
   Es Wird Ein Dhcp Discover Paket Aufgebaut Und Verschickt.
')
Declare Sub Dhcp_packet_filter
'( Aufruf aus: Udp_packet_filter
   Das Empfangene Paket Wird Geprft:
   Wenn Es Nicht An Die Eigene Ip Adresse Ging , Wird Es Abgewiesen
   Wenn Es Nicht Von Unserem Dns -server Kam , Wird Es Abgewiesen
   Ansonsten Wird Dns_reply_received Aufgerufen
')
Declare Function Dhcp_find_option(byval Opt As Byte) As Word
'( Aufruf z.B. aus: Udp_packet_filter
   Diese Funktion Durchsucht Den Gesamten Optionen -bereich Nach Einer Bestimmten Option
   (s.a. Dhcp_parse_options)
')
Declare Sub Dhcp_send_discover
'(
   Es Wird Ein Dhcp Discover Paket Aufgebaut Und Verschickt.
')
Declare Sub Dhcp_received_offer
'(
   Sobald Ein Dhcp Offer Paket Empfangen Wurde , Wird Es Mit Einem Dhcp Request Beantwortet.
')
Declare Sub Dhcp_send_request
'(
   Es Wird Ein Dhcp Request Paket Aufgebaut Und Verschickt.
   Im Dhcp Status Renew Wird Das Paket Direkt An Den Letzten Dhcp Server Geschickt,
   Im Dhcp Status Rebind Wird Das Paket Per Broadcast Gesendet.
')
Declare Sub Dhcp_received_ack
'(
   Wenn Der Dhcp Request Vom Server Besttigt Wird , Wird Der Dhcp Status Auf Bound Gesetzt.
   Die Empfangenen Parameter Werden ber Die Options Ausgelesen Und Die Einsprechenden Werte Gesetzt.
')
Declare Sub Dhcp_parse_options
'( Aufruf aus: Dhcp_received_ack
   Die Meisten Der Fr Dhcp Wichtigen Informationen Finden Sich Nicht An Festen Stellen Im Frame
   (der Eigentlich Ein Bootp Frame Ist) , Sondern In Dem Eigentlich Fr Option Vorgesehenen Bereich.
   Eine Option Beginnt Immer Mit Einem Kennungs -byte , Gefolgt Von 2 Lngenbytes , Dann Erst Die Eigentlichen Daten.
   Diese Funktion Durchluft Den Gesamten Optionen -bereich Und Wertet Die Jeweiligen Daten Aus.
')
Declare Sub Dhcp_received_nak
'(
   Wenn Der Dhcp Request Vom Server Abgelehnt Wird , Wird Der Dhcp Status Auf Init Zurckgesetzt.
')
#if Debug_dhcp > 2
Declare Sub Dhcp_dump_frame
'( Aufruf bei Bedarf
   Der Ghcp Frame Wird In Lesbarer Form ber Die Serielle Schnittstelle Ausgegeben.
')
'
#endif
Declare Function Dhcp_do_header(byval Msg_type As Byte) As Word
'( Baut das Header Frame ETH/IP in Buffer auf
')